/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityE_Interactable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPart;
import minecrafttransportsimulator.items.components.IItemEntityInteractable;
import minecrafttransportsimulator.jsondefs.AJSONPartProvider;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;
import minecrafttransportsimulator.packets.instances.PacketPlayerChatMessage;
import minecrafttransportsimulator.systems.LanguageSystem;

public class PacketEntityInteract
extends APacketEntityInteract<AEntityE_Interactable<?>, IWrapperPlayer> {
    private final Point3D hitBoxLocalCenter;
    private final boolean leftClick;
    private final boolean rightClick;

    public PacketEntityInteract(AEntityE_Interactable<?> entity, IWrapperPlayer player, BoundingBox hitBox, boolean leftClick, boolean rightClick) {
        super(entity, player);
        this.hitBoxLocalCenter = hitBox.localCenter;
        this.leftClick = leftClick;
        this.rightClick = rightClick;
    }

    public PacketEntityInteract(ByteBuf buf) {
        super(buf);
        this.hitBoxLocalCenter = PacketEntityInteract.readPoint3dFromBuffer(buf);
        this.leftClick = buf.readBoolean();
        this.rightClick = buf.readBoolean();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityInteract.writePoint3dToBuffer(this.hitBoxLocalCenter, buf);
        buf.writeBoolean(this.leftClick);
        buf.writeBoolean(this.rightClick);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityE_Interactable<?> entity, IWrapperPlayer player) {
        EntityVehicleF_Physics vehicle = entity instanceof EntityVehicleF_Physics ? (EntityVehicleF_Physics)entity : (entity instanceof APart ? ((APart)entity).vehicleOn : null);
        IWrapperItemStack heldStack = player.getHeldStack();
        AItemBase heldItem = heldStack.getItem();
        BoundingBox hitBox = null;
        if (this.rightClick && entity instanceof AEntityF_Multipart) {
            AEntityF_Multipart multipart = (AEntityF_Multipart)entity;
            for (Map.Entry<BoundingBox, JSONPartDefinition> slotEntry : multipart.partSlotBoxes.entrySet()) {
                if (!slotEntry.getKey().localCenter.equals(this.hitBoxLocalCenter)) continue;
                if (vehicle == null || !vehicle.lockedVar.isActive) {
                    if (heldItem instanceof AItemPart && !player.isSneaking() && multipart.addPartFromStack(heldStack, player, ((AJSONPartProvider)multipart.definition).parts.indexOf(slotEntry.getValue()), false, false) != null && !player.isCreative()) {
                        player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
                    }
                } else {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_LOCKED, new Object[0]));
                }
                return false;
            }
        }
        if (hitBox == null) {
            for (BoundingBox box : entity.collisionBoxes) {
                if (!box.localCenter.equals(this.hitBoxLocalCenter)) continue;
                hitBox = box;
                break;
            }
            if (hitBox == null) {
                if (this.rightClick || this.leftClick) {
                    InterfaceManager.coreInterface.logError("Got a packet for interacting with an entity, but don't have a hitbox for it, so we can't interact?  Interacting with: " + entity.toString());
                }
                return false;
            }
        }
        if (heldItem instanceof IItemEntityInteractable && (this.rightClick || this.leftClick)) {
            switch (((IItemEntityInteractable)((Object)heldItem)).doEntityInteraction(entity, hitBox, player, this.rightClick)) {
                case ALL: {
                    return true;
                }
                case PLAYER: {
                    player.sendPacket(this);
                    return false;
                }
                case NONE: {
                    return false;
                }
            }
        }
        if (!this.leftClick && hitBox.definition != null && hitBox.definition.action != null) {
            if (vehicle != null && vehicle.lockedVar.isActive) {
                if (this.rightClick) {
                    player.sendPacket(new PacketPlayerChatMessage(player, LanguageSystem.INTERACT_VEHICLE_LOCKED, new Object[0]));
                }
            } else if (hitBox.definition.action != null) {
                entity.performAction(hitBox.definition.action, this.rightClick);
            }
            return false;
        }
        if (this.rightClick) {
            entity.interact(player);
        } else if (this.leftClick && (hitBox.groupDef == null || hitBox.groupDef.armorThickness == 0.0f)) {
            entity.attack(new Damage(1.0, entity.boundingBox, null, player, null).setHand());
        }
        return false;
    }
}

